//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//class for management of captured events, and eventually sending OSC to Fredrik

//contention- don't need onoff, can just use pause? 

CaptureEventsManager {
var <buflength,<rhythmsize,<triggerID, <>oscout;
var <capturebus,<spreadbus,<slopebus,<onoffbus;
var <eventbuf, <bufsize, <bufnum;
var synth;
var ceoscrespondernode;
var <list,<rhythmlist,<rhythmindex;
var idcounter; //for OSC event tags
var s;
var laststart;

//SynthDef for event playback
*initClass {

StartUp.add({

SynthDef.writeOnce("ceplaybuf",{
arg out=0, bufnum=0, offset=0, rate=1.0, len=0.1, amp=1.0, pan=0.0; 
var inner;

//need the BufRateScale to cope with Sample Rate differences
inner= amp*PlayBuf.ar(1,bufnum,rate*BufRateScale.kr(bufnum), 1.0, offset, 1.0) 
*Line.ar(1,1,len,doneAction:2);

Out.ar(out,Pan2.ar(inner, pan));
});		
		
});		
		
}

*new { arg buflength=10,rhythmsize=20,triggerID=50, oscout;

^super.newCopyArgs(buflength,rhythmsize,triggerID, oscout).initCaptureEventsManager(oscout);
}

initCaptureEventsManager {	
	var start,end,size,tempend, latestid, rmindex, now, ioi;
	
	idcounter=0; //SORT OUT OSC DETAILS
	
	s=Server.default;
	
	eventbuf=Buffer.alloc(s,44100*buflength,1);
	bufnum= eventbuf.bufnum;
	
	capturebus= Bus.control(s,1);
	spreadbus= Bus.control(s,1);
	slopebus= Bus.control(s,1);
	onoffbus= Bus.control(s,1);
	
	//initial values
	capturebus.set(8);
	spreadbus.set(5);
	slopebus.set(0.3);
	onoffbus.set(1);
	
	bufsize=eventbuf.numFrames; 
	 
	list= LinkedList.new;
	rhythmlist= Array.fill(rhythmsize,{1.0}); //last twenty
	
	laststart=Main.elapsedTime;
	rhythmindex=(rhythmsize-1);
	
	latestid=0;
	
	// register to receive this message
	ceoscrespondernode= OSCresponderNode(s.addr,'/tr',{	 arg time,responder,msg;
		var id; 
		
		id=msg[2];
		
		if((id==triggerID) || (id==(triggerID+1)),{	
			
			if(latestid!=id,{
				latestid=id;
				start=(msg[3]).asInteger;
			},{
				end=(msg[3]).asInteger;
				
				size= if(end<start,{end+bufsize-start},{end-start});
				
				//find any to remove after start or before end- find first that is safe, remove all before it
				
				rmindex=1.neg;
				//any value below start, add b.numFrames
				
				list.do({arg event,i; var eventstart,eventend; 
					eventstart=event[0];
					eventend=event[1];
					
					//eventstart.postln;
					//eventend.postln;
					
					tempend= if(end<start,{end+bufsize},{end});
					
					if(eventstart<start,{eventstart= eventstart+bufsize});
					if(eventend<start,{eventend= eventend+bufsize});
					
					if( (eventstart>eventend) ||  (eventstart<=tempend) || (eventend<=tempend), {
					rmindex=i;
					});
				
				});
				
				(rmindex+1).do({list.popFirst;});
				
				//don't store if size too small? 
				//Post << [start,end,size/44100.0] <<nl;
				
				
//new event, ID is size of list at the moment

idcounter=(idcounter+1)%60;

//adjust for transmission time? endtime is just now, this osc was sent to lang at finalising of capture
oscout.addmessageglobal(["captrecordeventID",idcounter,"captstarttime",(size/44100.0).neg,"captendtime",0.0],0); //instance 0

				
				
				list.add([start,end,size/44100.0,idcounter]);
								
				//update rhythms
				now= Main.elapsedTime- (size/44100.0); //get start time of detection
				
				ioi= now-laststart;
				
				rhythmindex=(rhythmindex+1)%(rhythmsize);
				
				//can get latest using ~rhythmindex
				rhythmlist[rhythmindex]= ioi;
				
				laststart= now; 
				
				//Post << ~list <<nl;
				//Post << ~list.size <<nl;
			});
		});
		
	}).add;
	
	
	
	
}


play {arg target;

synth=SynthDef(\capturer,{CaptureEvents.ar(InFeedback.ar(In.kr(capturebus.index,1),1),eventbuf.bufnum,In.kr(spreadbus.index),In.kr(slopebus.index),In.kr(onoffbus.index),triggerID)}).play(target, addAction:\addToTail);

oscout.addmessageglobal(["captonoff",1],0);

}


play2 {arg target;

synth=SynthDef(\capturer2,{CaptureEvents2.ar(InFeedback.ar(In.kr(capturebus.index,1),1),eventbuf.bufnum,In.kr(spreadbus.index),In.kr(slopebus.index),triggerID)}).play(target, addAction:\addToTail);

oscout.addmessageglobal(["captonoff",1],0); 

}


//don't need onoffbus argument? 
run {arg bool=true;

//make sure you update last rhythm time, else goes to sleep! 

//send Fredrik stop or start
oscout.addmessageglobal(["captonoff",if(bool,1,0)],0); 
//instance 0 stop 0 start 1



if(bool,{laststart=Main.elapsedTime;});


synth.run(bool);
}

 
kill {arg bool=true;
ceoscrespondernode.remove;
synth.free;
}


playLastEvent{arg busindex=0,rate=1.0,lengthmult=1.0,amp=1.0, pan=0.0;
var event;

this.playEvent(list.size-1,busindex,rate,lengthmult,amp, pan);

^list.last[2];
}

playEvent {arg which=0, busindex=0,rate=1.0,lengthmult=1.0,amp=1.0, pan=0.0;

var event,id;

event= list.wrapAt(which);

id= event[3];

oscout.addmessageglobal(["captplayeventID",id],0); //instance 0

if (event.notNil,{
s.sendMsg("/s_new", "ceplaybuf", -1,0,0, \out,busindex, \bufnum,eventbuf.bufnum, \rate,rate,\offset,event[0],\len,(event[2]*lengthmult),\amp,amp, \pan, pan);
});

}

playEventParams {arg which;

var event,id;

which=which ?? {list.size-1};

event= list.wrapAt(which);

id= event[3];

oscout.addmessageglobal(["captplayeventID",id],0); //instance 0

if (event.notNil,{
//bufnum, offset,dur
^ [eventbuf.bufnum,event[0],event[2]];
});

}


getLastNRhythm {arg n=5;
var indexnow,indexthen;

if(n>rhythmsize, {n=rhythmsize});

indexnow=rhythmindex;
indexthen=(indexnow-n)%(rhythmsize);

^if(indexthen>indexnow,{
(rhythmlist.copyRange(0,indexnow))++(rhythmlist.copyRange(indexthen,rhythmsize-1))
},{rhythmlist.copyRange(indexthen,indexnow)});

}


}